
source("utils.R")
# utils.R : mean1 version 
# Assume that you have 2 dataframes : 
#   
#   1) df ( consists of F, X1, ... , X6, A, Y )
#   2) W  (consists pf X*, F) : X* is transformed covariates.


df = readRDS("simulated_data/df.rds")
W = readRDS("simulated_data/W.rds")

### Optimization based grouping

# Weight.via.Opt(df, W, method, ...)


### Visualization

## PLOT 1 (FAIRNESS DISTRIBUTION)
# let 'result' be a output of IPW_method or Weight.via.Opt function
# fairness_vis(result$finaldf)

## PLOT 2,3 (Covariate Balance for each subgroup)
# covbal_vis(result, subgroup index, lowerbound of quantile, upperbound of quantile)

Opt = Weight.via.Opt(df, W, method="KR25", delta=0.001, delta_prime=10, gamma=0.01)






thresholds1 <- data.frame(
  variable = c("X1", "X2", "X3"),#, "X4", "X5", "X6"),
  lb = c(0.00, 0.00, 0.02),#, 0, 0, 0),   # 예시
  ub = c(0.99, 0.95, 0.99)#, 0.95, 0.95, 0.95)    
)
thresholds2 <- data.frame(
  variable = c("X1", "X2", "X3", "X4", "X5", "X6"),
  lb = c(0, 0.01, 0.02),#, 0, 0, 0),   
  ub = c(1, 0.99, 1)#, 0.95, 0.95, 0.99)   
)

fairness_vis(Opt$final)
covbal_vis(Opt, subgroup.no = 1, thresholds1)
covbal_vis(Opt, subgroup.no = 2, thresholds2)